# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 4
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def mutual_trust_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "C") / len(opp_history) if opp_history else 1.0
    
    # Early rounds: Build trust with unconditional cooperation
    if current_round <= 3:
        return "C"
    
    # Mid rounds: Strategic exploitation based on opponent's behavior
    elif 4 <= current_round <= 7:
        if current_round == 4:
            return "D"  # Unexpected defection to catch opponent off guard
        else:
            if opp_history[-1] == "C":
                return "D" if random.random() < 0.7 else "C"  # Exploit cooperation
            else:
                return "C"  # Avoid retaliation
    
    # Late rounds: Aggressive defection
    elif 8 <= current_round <= 10:
        return "D"
    
    # Fallback (shouldn't be reached)
    return "D"